@section('title',  $paginas->titulo )
@section('meta-etiquetas')
	<meta name="description" content="{{  $paginas->meta_description }}" />
	<meta name="keywords" content="{{  $paginas->meta_keywords }}"/>


	 <meta property="og:type" content="website" />
	 <meta property="og:title" content="{{ $paginas->titulo_seo }}" />
	 <meta property="og:description" content="{{  $paginas->meta_description }}" />
	 <meta property="og:url" content="http://inventivaclick.com/{{  $paginas->slug }}" />
	 <meta property="og:site_name" content="{{  $paginas->titulo_seo }}" />
	 <meta property="og:image" content="http://inventivaclick.com/images/{{  $paginas->imagen }}" />

	 <meta name="twitter:card" content="summary"/>
	 <meta name="twitter:description" content="{{  $paginas->meta_description }}"/>
	 <meta name="twitter:title" content="{{ $paginas->titulo_seo }}"/>
	<meta name="twitter:image" content="http://inventivaclick.com/images/{{  $paginas->imagen }}" />


@stop

@section('css-paginas')
<link href="/libreria/carousel/css/owl.carousel.min.css" rel="stylesheet" media="all">
 <link rel="stylesheet" href="css/slider-servicios.css">

 <!-- CSS para efecto 3d-->
<!--<link rel="stylesheet" href="css/servicios/reset.css">  CSS reset -->
<!--<link rel="stylesheet" href="css/servicios/style.css">  Resource style --> 
 <!-- fin CSS para efecto 3d-->
 <style>
 	 {!! $paginas->style !!}
 </style>
@stop

@section('content-pages')
<!-- MENU DEL LADO DERECHO PARA SELECCIONAR EL SLIDER-->
<div class="nav-right-menu">
	<ul>
		@foreach($servicios as $s)
		@php $nombreSlide = str_replace(' ', '_', $s->nombre); @endphp
		<li class="to-slide li-icon hvr-wobble-horizontal" data-slider="{{$nombreSlide}}">
			<img src="/public/images/y88oKHkwS6bJWEvPi8nLKOge0sajFDODiPcxnK9C.png" style="width: 18px;">
			<span class="icon-service"><img class="icon" src="images/{{$s->icono}}" data-slider="{{$nombreSlide}}"></span>{{$s->nombre}}
		</li>
		@endforeach
	</ul>
</div>

<div class="nav-right-menu-mobile">
	<ul>
		@foreach($servicios as $s)
		@php $nombreSlide = str_replace(' ', '_', $s->nombre); @endphp
		<li class="to-slide li-icon slide-mobile" data-slider="{{$nombreSlide}}">
			<span class="icon-service" ><img class="icon-mobile" src="images/{{$s->icono}}" data-slider="{{$nombreSlide}}"></span>
		</li>
		@endforeach
	</ul>
</div>


<!-- servicios slider -->
	 
		<div class="content-slider">
		    <div id="slider" class="carousel slide" data-ride="carousel"  data-interval="5000">
		    <ul class="carousel-indicators" style="display: none;">
		    	<li data-target="#slider" data-slide-to="0" class="active"></li>
		    	@for ($i = 1; $i < $cantidad_sliders; $i++)
				     <li data-target="#slider" data-slide-to="{{ $i }}"></li>
				@endfor
		      
		    </ul>
		    <div class="carousel-inner">

		    	 
		    	@forelse ($slider as $sli)
		    	@php $nombreSlide = str_replace('servicio', '', $sli->nombre); @endphp
		    	@php $nombreSlide = str_replace(' ', '_', $nombreSlide); @endphp
					@if ($loop->first)
				         <div class="carousel-item active" data-slide="{{$nombreSlide}}"><!-- active-->
					        <section class="section-slider-i">
					          <div class="img-f-slider" style="background-image:url(images/{{ $sli->portada }}); ">
					          </div>
					          <div class="contenedor-slider">
					            <div class="grid-content-slider">
					              
					              <div class="itemslid2 hvr-grow-rotate"> 
					                <img src="images/{{$sli->img  }}" alt="" class="img-slider img-slider1">
					              </div>
					              <div class="itemslid1">
					              	<div class="">
					                 {!! $sli->contenido !!}
					             	</div>
					                <a href="{{ $sli->link_btn }}" class="btn btn-inventiva hvr-pulse-shrink">{{ $sli->texto_btn }}</a>
					              </div>
					            </div>
					          </div> 
					        </section>  
					     </div>
				    @else
						<div class="carousel-item" data-slide="{{$nombreSlide}}"><!-- active-->
					        <section class="section-slider-i">
					          <div class="img-f-slider" style="background-image:url(images/{{ $sli->portada }}); ">
					          </div>
					          <div class="contenedor-slider">
					            <div class="grid-content-slider">
					              
					              <div class="itemslid2 hvr-grow-rotate"> 
					                <img src="images/{{$sli->img  }}" alt="" class="img-slider img-slider1">
					              </div>
					              <div class="itemslid1">
					                 <div class="">
					                 {!! $sli->contenido !!}
					             	 </div>
					                <a href="{{ $sli->link_btn }}" class="btn btn-inventiva hvr-pulse-shrink">{{ $sli->texto_btn }}</a>
					              </div>
					            </div>
					          </div> 
					        </section>  
					     </div>
				    @endif
				     
				@empty
				    <div class="container">
				    	Al parecer no existen sliders en la Web!!, intente desde el administrador crear nuevos sliders.
				    </div>
				@endforelse
		      
		    </div>
		    <a class="carousel-control-prev" href="#slider" data-slide="prev">
		      <span class="carousel-control-prev-icon"></span>
		    </a>
		    <a class="carousel-control-next" href="#slider" data-slide="next">
		      <span class="carousel-control-next-icon"></span>
		    </a>
		  </div>
		</div>
		
	  <!-- Fin Slider -->

@stop


@section('javascript-page')
 <script src="js/jquery.touchSwipe.min.js"></script>
<script src="js/bootstrap-touch-slider.js"></script>
    
   <script type="text/javascript">
    $('#slider').bsTouchSlider();
	</script>
<script src="libreria/carousel/js/owl.carousel.min.js"></script>
<!--<script src="libreria/efectoparallax3d/main.js"></script>-->
  <script>
        $(document).ready(function() {
          $('.owl-carousel').owlCarousel({
            loop: true,
            margin: 10,
            responsiveClass: true,
            responsive: {
              0: {
                items: 1,
                nav: true
              },
              500: {
                items: 2,
                nav: false
              },
              600: {
                items: 3,
                nav: false
              },
              1000: {
                items: 4,
                nav: true,
                loop: false,
                margin: 20
              }
            }
          })
          $(".carousel").carousel({
				interval: 5000
			});
        //CODIGO JS PARA SELECCIONAR EL SLIDER SEGUN EL SERVICIO SELECCIONADO
		$(".to-slide, .icon").click(function(e){
			var sliderTo = '_' + e.target.dataset.slider.toLowerCase();
			console.log(e.target.dataset.slider);
			$(".carousel-item").each(function(){
				var slider = $(this)[0].dataset.slide.toLowerCase();
				if(slider == sliderTo){
					$(this).addClass('carousel-item-left');
					$(this).addClass('active');
					$(this).removeClass('carousel-item-left');
				}else{
					$(this).removeClass('active');
				}
			});
		});		
		//CODIGO JS PARA SELECCIONAR EL SLIDER SEGUN EL SERVICIO SELECCIONADO
		$(".slide-mobile, .icon-mobile").click(function(e){
			var sliderTo = '_' + e.target.dataset.slider.toLowerCase();
			$(".carousel-item").each(function(){
				var slider = $(this)[0].dataset.slide.toLowerCase();
				if(slider == sliderTo){
					$(this).addClass('carousel-item-left');
					$(this).addClass('active');
					$(this).removeClass('carousel-item-left');
				}else{
					$(this).removeClass('active');
				}
			});
		});		
     });

  </script>
   <script type="javascript">
   	   {!! $paginas->resumen !!}
   </script>
@stop