<?php
/**
	Add Staff Grid Shortcode
**/
if( !function_exists( 'vcex_staff_grid_shortcode' ) ) {

	function vcex_staff_grid_shortcode($atts) {
		
		// Define shortcode params
		extract( shortcode_atts( array(
				'unique_id'				=> '',
				'term_slug'				=> '',
				'include_categories'	=> '',
				'exclude_categories'	=> '',
				'posts_per_page'		=> '',
				'grid_style'			=> 'fit_columns',
				'columns'				=> '',
				'order'					=> 'DESC',
				'orderby'				=> 'date',
				'filter'				=> 'true',
				'thumbnail_link'		=> 'post',
				'img_crop'				=> 'true',
				'img_width'				=> '9999',
				'img_height'			=> '9999',
				'thumb_link'			=> 'post',
				'img_filter'			=> '',
				'title'					=> 'true',
				'title_link'			=> 'post',
				'excerpt'				=> 'true',
				'excerpt_length'		=> '15',
				'read_more'				=> 'false',
				'read_more_text'		=> __( 'read more', 'vcex' ),
				'pagination'			=> 'false',
				'filter_content'		=> 'false',
				'social_links'			=> 'true',
				'offset'				=> 0,
				'taxonomy'				=> '',
				'terms'					=> '',
				'img_hover_style'		=> '',
				'img_overlay_disable'	=> '',
				'img_rendering'			=> '',
				'all_text'				=> __( 'All', 'wpex' ),
			), $atts));
			
		// Get global $post var
		global $post;

		// Don't create custom tax if tax doesn't exist
		if ( taxonomy_exists( 'staff_category' ) ) {
			
			// Include categories
			$include_categories = ( '' != $include_categories ) ? $include_categories : $term_slug;
			$include_categories = ( 'all' == $include_categories ) ? '' : $include_categories;
			$filter_cats_include = '';
			if ( $include_categories ) {
				$include_categories = explode( ',', $include_categories );
				$filter_cats_include = array();
				foreach ( $include_categories as $key ) {
					$key = get_term_by( 'slug', $key, 'staff_category' );
					$filter_cats_include[] = $key->term_id;
				}
			}

			// Exclude categories
			$filter_cats_exclude = '';
			if ( $exclude_categories ) {
				$exclude_categories = explode( ',', $exclude_categories );
				if( ! empty( $exclude_categories ) && is_array( $exclude_categories ) ) {
				$filter_cats_exclude = array();
				foreach ( $exclude_categories as $key ) {
					$key = get_term_by( 'slug', $key, 'staff_category' );
					$filter_cats_exclude[] = $key->term_id;
				}
				$exclude_categories = array(
						'taxonomy'	=> 'staff_category',
						'field'		=> 'slug',
						'terms'		=> $exclude_categories,
						'operator'	=> 'NOT IN',
					);
				} else {
					$exclude_categories = '';
				}
			}

			// Start Tax Query
			if( ! empty( $include_categories ) && is_array( $include_categories ) ) {
				$include_categories = array(
					'taxonomy'	=> 'staff_category',
					'field'		=> 'slug',
					'terms'		=> $include_categories,
					'operator'	=> 'IN',
				);
			} else {
				$include_categories = '';
			}

		}

		// Pagination var
		if( $pagination == 'true' ) {
			global $paged;
			$paged = get_query_var('paged') ? get_query_var('paged') : 1;
		} else {
			$paged = NULL;
		}
		
		// The Query
		$vcex_query = new WP_Query(
			array(
				'post_type'			=> 'staff',
				'posts_per_page'	=> $posts_per_page,
				'offset'			=> $offset,
				'order'				=> $order,
				'orderby'			=> $orderby,
				'filter_content'	=> $filter_content,
				'paged'				=> $paged,
				'tax_query'			=> array(
					'relation'		=> 'AND',
					$include_categories,
					$exclude_categories,
				),
			)
		);

		//Output posts
		if( $vcex_query->posts ) :
		
			$rand_num = rand(1, 100);
			$unique_id = $unique_id ? $unique_id : 'staff-'. rand( 1, 100 );
			$img_crop = $img_crop == 'true' ? true : false;
			$read_more = $read_more == 'true' ? true : false;
			
			// Set correct grid class
			$col_class = 'span_8';
			if ( $columns == '1' ) $col_class = 'span_1_of_1';
			if ( $columns == '2' ) $col_class = 'span_1_of_2';
			if ( $columns == '3' ) $col_class = 'span_1_of_3';
			if ( $columns == '4' ) $col_class = 'span_1_of_4';
			if ( $columns == '5' ) $col_class = 'span_1_of_5';
			if ( $columns == '6' ) $col_class = 'span_1_of_6';
			if ( $columns == '7' ) $col_class = 'span_1_of_7';
			if ( $columns == '8' ) $col_class = 'span_1_of_8';
			if ( $columns == '9' ) $col_class = 'span_1_of_9';
			if ( $columns == '10' ) $col_class = 'span_1_of_10';
			if ( $columns == '11' ) $col_class = 'span_1_of_11';
			if ( $columns == '12' ) $col_class = 'span_1_of_12';
			
			// Looad lightbox scripts
			if ( $thumb_link == 'lightbox' ) {
				wp_enqueue_script( 'vcex-magnific-popup' );
				wp_enqueue_script( 'vcex-lightbox' );
			}
			
			// Load Masonry scripts
			if ( $filter == 'true' || $grid_style == 'masonry' ) {
				wp_enqueue_script( 'vcex-isotope' ); // Load Isotope Script
			}
			
			ob_start(); ?>
			
				<?php
				// Display filter links
				if ( $filter == 'true' && taxonomy_exists( 'staff_category' ) ) {
					$terms = get_terms( 'staff_category', array(
						'include'	=> $filter_cats_include,
						'exclude'	=> $filter_cats_exclude,
					) );
					$terms = apply_filters( 'vcex_staff_grid_get_terms', $terms );
					if( $terms ) { ?>
						<ul class="vcex-staff-filter filter-<?php echo $unique_id; ?> vcex-filter-links clr">
							<li class="active"><a href="#" data-filter="*"><span><?php echo $all_text; ?></span></a></li>
							<?php foreach ($terms as $term ) : ?>
								<li><a href="#" data-filter=".cat-<?php echo $term->term_id; ?>"><?php echo $term->name; ?></a></li>
							<?php endforeach; ?>
						</ul><!-- .vcex-staff-filter -->
					<?php } ?>
				<?php } ?>
				
				<?php
				if ( $filter == 'true' || $grid_style == 'masonry' ) { ?>
				<script type="text/javascript">
				jQuery(function($){
					$(window).load(function() {
							function wpexStaffIsotope() {
								var $container = $('#<?php echo $unique_id; ?>');
								$container.isotope({
									itemSelector: '.staff-entry',
									animationEngine: 'css',
									layoutMode: 'masonry'
								});
							} wpexStaffIsotope();
							var $filterLinks = $('.filter-<?php echo $unique_id; ?> a');
							$filterLinks.each( function() {
								var $filterableDiv = $(this).data('filter');
								if ( $filterableDiv == '*' ) {
									// ignore this one
								} else {
									if ( $($filterableDiv).width() ) {
										// keep these
									} else {
										// remove these
										$(this).parent().hide();
									}
								}
							});
							$filterLinks.css({ opacity: 1 } );
							$filterLinks.click(function(){
							var selector = $(this).attr('data-filter');
								$('#<?php echo $unique_id; ?>').isotope({ filter: selector });
								$(this).parents('ul').find('li').removeClass('active');
								$(this).parent('li').addClass('active');
							return false;
							});
							var isIE8 = $.browser.msie && +$.browser.version === 8;
							if (isIE8) {
								document.body.onresize = function () {
									wpexStaffIsotope();
								};
							} else {
								$(window).resize(function () {
									wpexStaffIsotope();
								});
							}
							window.addEventListener("orientationchange", function() {
								wpexStaffIsotope();
							});
					});
				});
				</script>
				<?php } ?>
		
				<div class="wpex-row vcex-staff-grid vcex-clearfix <?php if ( $filter == 'true' || $grid_style == 'masonry' ) { echo 'vcex-masonry-grid'; } ?>" id="<?php echo $unique_id; ?>">
					<?php
					// Define counter var to clear floats
					$count='';
					// Start loop
					foreach ( $vcex_query->posts as $post ) : setup_postdata( $post );
						// Define post ID var
						$post_id = $post->ID;
						// Add to the counter var
						$count++;
						// Add classes to the entries
						$entry_classes = 'staff-entry col';
						// Column class
						$entry_classes .= ' '. $col_class;
						// Counter
						$entry_classes .= ' col-'. $count;
						// Image rendering
						if ( $img_rendering ) {
							$entry_classes .= ' vcex-image-rendering-'. $img_rendering;
						}
						// Categories
						if ( taxonomy_exists( 'staff_category' ) ) {
							$post_terms = get_the_terms( $post, 'staff_category' );
							if ( $post_terms ) {
								foreach ( $post_terms as $post_term ) {
									$entry_classes .= ' cat-'. $post_term->term_id;
								}
							}
						} ?>
						<article id="#post-<?php the_ID(); ?>" class="<?php echo $entry_classes; ?>">
							<?php
								//Featured Image
								if( has_post_thumbnail() ) {
								// Image Filter class
								$img_filter_class = $img_filter ? 'vcex-'. $img_filter : '';
								// Image hover styles
								$img_hover_style_class = $img_hover_style ? 'vcex-img-hover-parent vcex-img-hover-'. $img_hover_style : ''; ?>
								<div class="staff-entry-media <?php echo $img_filter_class; ?> <?php echo $img_hover_style_class; ?>">
									<?php if ( 'post' == $thumb_link || 'lightbox' == $thumb_link ) { ?>
										<?php if ( 'post' == $thumb_link ) { ?>
											<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>">
										<?php } ?>
										<?php if ( $thumb_link == 'lightbox' ) { ?>
											<a href="<?php echo wp_get_attachment_url( get_post_thumbnail_id() ); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" class="vcex-lightbox">
										<?php } ?>
									<?php } ?>
										<img src="<?php echo aq_resize( wp_get_attachment_url( get_post_thumbnail_id() ), intval($img_width),  intval($img_height), $img_crop ); ?>" alt="<?php the_title(); ?>" class="staff-entry-img" />
									<?php if ( 'post' == $thumb_link || 'lightbox' == $thumb_link ) { ?>
										<?php if ( $img_filter !== 'grayscale' ) {
											if ( 'yes' != $img_overlay_disable ) {
												// Display Staff Position
												if ( '' != get_post_meta( get_the_ID(), 'wpex_staff_position', true ) && function_exists('wpex_get_staff_overlay') ) echo wpex_get_staff_overlay();
											}
										} ?>
										</a>
									<?php } ?>
									<?php
									// Display Staff Position
									if ( 'yes' != $img_overlay_disable ) {
										if ( 'grayscale' != $img_filter && 'nowhere' == $thumb_link && function_exists('wpex_get_staff_overlay') ) {
											echo wpex_get_staff_overlay();
										}
									} ?>
								</div><!-- .staff-dia -->
							<?php } ?>
							<?php if ( 'true' == $title || 'true' == $excerpt || 'true' == $read_more ) { ?>
								<div class="staff-entry-details clr">
									<?php if ( $title == 'true' ) { ?>
										<h2 class="staff-entry-title">
											<?php if ( 'post' == $title_link ) { ?>
												<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a>
											<?php } else { ?>
												<?php the_title(); ?>
											<?php } ?>
										</h2>
									<?php } ?>
									<?php if ('true' ==  $excerpt ) {
										if ( 'true' != $excerpt ){
											$excerpt_length = '0';
										} ?>
										<div class="clr"></div>
										<div class="staff-entry-excerpt clr">
											<?php if ( '9999' == $excerpt_length  ) {
												the_content();
											} else {
												vcex_excerpt( $excerpt_length, false );
											} ?>
										</div>
									<?php } ?>
									<?php
									// Display social links
									if ( function_exists( 'wpex_get_staff_social' ) && 'true' == $social_links ) {
										echo wpex_get_staff_social( $post_id );
									}
									// Read more button
									if ( 'true' == $read_more ) { ?>
											<a href="<?php echo get_permalink(); ?>" title="<?php $read_more_text; ?>" rel="bookmark" class="vcex-readmore theme-button">
												<?php echo $read_more_text; ?> <span class="vcex-readmore-rarr">&rarr;</span>
											</a>
									<?php } ?>
								</div><!-- .staff-entry-details -->
							<?php } ?>
						</article><!-- .staff-entry -->
					<?php
					// Reset counter
					if ( $count == $columns ) {
						$count = '';
					} ?>
					<?php endforeach; ?>
				</div><!-- .vcex-staff-grid -->
				
				<?php
				// Paginate Posts
				if( $pagination == 'true' ) {
					$total = $vcex_query->max_num_pages;
					$big = 999999999; // need an unlikely integer
					if( $total > 1 )  {
					if( !$current_page = get_query_var('paged') )
						$current_page = 1;
					if( get_option('permalink_structure') ) {
						$format = 'page/%#%/';
					} else {
						$format = '&paged=%#%';
					}
					echo paginate_links(array(
						'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format'		=> $format,
						'current'		=> max( 1, get_query_var('paged') ),
						'total'			=> $total,
						'mid_size'		=> 2,
						'type'			=> 'list',
						'prev_text'		=> '<i class="fa fa-angle-left"></i>',
						'next_text'		=> '<i class="fa fa-angle-right"></i>',
					));
					}
				}
			
			endif; // End has posts check
					
			// Set things back to normal
			wp_reset_postdata();
		
		return ob_get_clean();
		
	}
	add_shortcode("vcex_staff_grid", "vcex_staff_grid_shortcode");
}




/**
	Add to Visual Composer
**/
$vc_img_rendering_url = 'https://developer.mozilla.org/en-US/docs/Web/CSS/image-rendering';
vc_map( array(
	"name"					=> __( "Staff Grid", 'vcex' ),
	"description"			=> __( "Recent staff posts grid", 'vcex' ),
	"base"					=> "vcex_staff_grid",
	"class"					=> "vcex_staff_grid",
	"category"				=> __( "Staff", "vcex" ),
	"icon" 					=> "icon-wpb-vcex-staff_grid",
	"params"				=> array(
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Unique Id", 'vcex' ),
			"param_name"	=> "unique_id",
			"value"			=> "",
			"description"	=> __( "You can enter a unique ID here for styling purposes.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Include Categories", 'vcex' ),
			"param_name"	=> "include_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to pull posts from or enter "all" to pull recent posts from all categories. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Exclude Categories", 'vcex' ),
			"param_name"	=> "exclude_categories",
			"admin_label"	=> true,
			"value"			=> "",
			"description"	=> __('Enter the slugs of a categories (comma seperated) to exclude. Example: category-1, category-2.','vcex'),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Order", 'vcex' ),
			"param_name"	=> "order",
			"value"			=> array(
				__( "DESC", "vcex")	=> "DESC",
				__( "ASC", "vcex" )	=> "ASC",
			),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Order By", 'vcex' ),
			"param_name"	=> "orderby",
			"value"			=> array(
				__( "Date", "vcex")				=> "date",
				__( "Name", "vcex" )			=> "name",
				__( "Modified", "vcex")			=> "modified",
				__( "Author", "vcex" )			=> "author",
				__( "Random", "vcex")			=> "rand",
				__( "Comment Count", "vcex" )	=> "comment_count",
			),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Columns", 'vcex' ),
			"param_name"	=> "columns",
			"value" 		=> array(
				__('Four','vcex')	=>'4',
				__('Three','vcex')	=>'3',
				__('Two','vcex')	=>'2',
				__('One','vcex')	=>'1',
			),
			"description"	=> __('Select how many columns for the grid.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Posts Per Page", 'vcex' ),
			"param_name"	=> "posts_per_page",
			"value"			=> "12",
			"description"	=> __( "How many posts do you wish to show?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Pagination", 'vcex' ),
			"param_name"	=> "pagination",
			"value"			=> array(
				__( "Yes", "vcex")	=> "false",
				__( "No", "vcex" )	=> "true",
			),
			"description"	=> __("Paginate posts? Important: Pagination will not work on your homepage because of how WordPress works","vcex"),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Grid Style", 'vcex' ),
			"param_name"	=> "grid_style",
			"value"			=> array(
				__( "Fit Columns", "vcex")	=> "fit-columns",
				__( "Masonry", "vcex" )		=> "masonry",
			),
			"description"	=> __( 'Select a grid style. If you select no margins be sure to crop your featured images to the same dimensions.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Category Filter", 'vcex' ),
			"param_name"	=> "filter",
			"value"			=> array(
				__( "Yes", "vcex")	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Do you wish to display an animated category filter?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( 'Custom Category Filter "All" Text', 'vcex' ),
			"param_name"	=> "all_text",
			"value"			=> "",
			"description"	=> __( 'Custom text for the "all" button in the category filter.', 'vcex' ),
			"dependency"	=> Array(
				'element'	=> "filter",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Image Width", 'vcex' ),
			"param_name"	=> "img_width",
			"value"			=> "9999",
			"description"	=> __( "Custom image cropping width. Enter 9999 for no cropping.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Image Height", 'vcex' ),
			"param_name"	=> "img_height",
			"value"			=> "9999",
			"description"	=> __( "Custom image cropping height. Enter 9999 for no cropping.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Image Filter", 'vcex' ),
			"param_name"	=> "img_filter",
			"value"			=> vcex_image_filters(),
			"description"	=> __( "Select a custom filter style for your images.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Image Links To", 'vcex' ),
			"param_name"	=> "thumb_link",
			"value"			=> array(
				__( "Post", "vcex")			=> "post",
				__( "Lightbox", "vcex" )	=> "lightbox",
				__( "Nowhere", "vcex" )		=> "nowhere",
			),
			"description"	=> __( "Default link behaviour on the images.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Image Overlay?", 'vcex' ),
			"param_name"	=> "img_overlay_disable",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "",
				__( "No", "vcex" )	=> "yes",
			),
			"description"	=> __("Display the default overlay when a user hovers over the featured image?", "vcex"),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "CSS3 Image Hover", 'vcex' ),
			"param_name"	=> "img_hover_style",
			"value"			=> vcex_image_hovers(),
			"description"	=> __("Select your preferred image hover effect. Please note this will only work if the image links to a URL or a large version of itself. Please note these effects may not work in all browsers.", "vcex"),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Image Rendering", 'vcex' ),
			"param_name"	=> "img_rendering",
			"value"			=> vcex_image_rendering(),
			"description"	=> sprintf( __( 'Image-rendering CSS property provides a hint to the user agent about how to handle its image rendering. For example when scaling down images they tend to look a bit fuzzy in Firefox, setting image-rendering to crisp-edges can help make the images look better. <a href="%s">Learn more</a>.', 'vcex' ), esc_url( $vc_img_rendering_url ) )
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Title", 'vcex' ),
			"param_name"	=> "title",
			"value"			=> array(
				__( "Yes", "vcex" )	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Display post title?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Title Links To", 'vcex' ),
			"param_name"	=> "title_link",
			"value"			=> array(
				__( "Post", "vcex")		=> "post",
				__( "Nowhere", "vcex" )	=> "nowhere",
			),
			"dependency"	=> Array(
				'element'	=> "title",
				'value'		=> "true"
			),
			"description"	=> __( "Default link behaviour on the titles.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Excerpt", 'vcex' ),
			"param_name"	=> "excerpt",
			"value"			=> array(
				__( "Yes", "vcex")		=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( "Display post excerpt?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Excerpt Length", 'vcex' ),
			"param_name"	=> "excerpt_length",
			"value"			=> "30",
			"dependency"	=> Array(
				'element'	=> "excerpt",
				'value'		=> "true"
			),
			"description"	=> __( 'Enter a custom excerpt length. Will trim the excerpt by this number of words. Enter "9999" to display the_content instead of the auto excerpt.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Read More", 'vcex' ),
			"param_name"	=> "read_more",
			"value"			=> array(
				__( "No", "vcex" )		=> "false",
				__( "Yes", "vcex")		=> "true",
			),
			"description"	=> __( "Display post readmore button after excerpt?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Read More Text", 'vcex' ),
			"param_name"	=> "read_more_text",
			"value"			=> "",
			"description"	=> __("Enter your custom text for the readmore button.","vcex"),
			"dependency"	=> Array(
				'element'	=> "read_more",
				'value'		=> "true"
			),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Social Links", 'vcex' ),
			"param_name"	=> "social_links",
			"value"			=> array(
				__( "Yes", "vcex")	=> "true",
				__( "No", "vcex" )	=> "false",
			),
			"description"	=> __( 'Display social links?', 'vcex' ),
		),
	)
) );