<?php
/**
	Register shortcode
**/
if( !function_exists('vcex_spacing_shortcode') ) {
	function vcex_spacing_shortcode( $atts ) {
		extract( shortcode_atts( array(
			'size'	=> '20px',
			'class'	=> '',
		),
		$atts ) );
	 return '<hr class="vcex-spacing '. $class .'" style="height: '. $size .'" />';
	}
}
add_shortcode( 'vcex_spacing', 'vcex_spacing_shortcode' );


/**
	Add to visual composer
**/
vc_map( array(
	"name"					=> __( "Spacing", 'vces' ),
	"description"			=> __( "Adds spacing anywhere you need it.", 'vcex' ),
	"base"					=> "vcex_spacing",
	"category"				=> __('Content', 'js_composer'),
	"icon"					=> "icon-wpb-vcex-spacing",
	"params"				=> array(
		array(
			"type"			=> "textfield",
			"admin_label"	=> true,
			"class"			=> "",
			"heading"		=> __( "Spacing", 'vcex' ),
			"param_name"	=> "size",
			"value"			=> "30px",
			"description"	=> __( "Enter a height in pixels for your spacing.", 'vcex' )
		),
		array(
			"type"			=> "textfield",
			"admin_label"	=> true,
			"class"			=> "",
			"heading"		=> __( "Clasname", 'vcex' ),
			"param_name"	=> "class",
			"value"			=> "",
			"description"	=> __( "Give your spacing module a classname for styling purposes.", 'vcex' )
		),
	)
) );
?>