<?php
/**
	Register Shortcode
**/
if( !function_exists( 'vcex_image_galleryslider_shortcode' ) ) {

	function vcex_image_galleryslider_shortcode($atts) {
		
		// Define shortcode params
		extract( shortcode_atts( array(
				'unique_id'				=> '',
				'image_ids'				=> '',
				'animation'				=> 'fade',
				'slideshow'				=> 'true',
				'randomize'				=> 'false',
				'direction'				=> 'horizontal',
				'slideshow_speed'		=> '7000',
				'animation_speed'		=> '600',
				'pause_on_hover'		=> 'true',
				'smooth_height'			=> 'true',
				'thumbnail_link'		=> 'lightbox',
				'custom_links'			=> '',
				'custom_links_target'	=> '_self',
				'img_width'				=> '9999',
				'img_height'			=> '9999',
				'img_thumb_width'		=> '200',
				'img_thumb_height'		=> '200',
				'caption'				=> 'true',
				'img_rendering'			=> '',
			), $atts ) );
			
		if ( empty($image_ids) ) echo __( 'Please select your images for your slider', 'vcex' );
			
		$output = '';
		
		// Required Scripts
		wp_enqueue_script( 'vcex-galleryslider' );
		
		// Give galleryslider a unique name
		$rand_num = rand(1, 100);
		$unique_galleryslider_id	= 'galleryslider-'. $rand_num;
		
		// Output filter JS into the footer like a WP Jedi Master
		$output .='
			<script type="text/javascript">
				jQuery(function($){
					$(window).load(function() {
						$("#'. $unique_galleryslider_id .'").flexslider({
							animation: "'. $animation .'",
							slideshow : '. $slideshow .',
							randomize : '. $randomize .',
							direction: "'. $direction .'",
							slideshowSpeed: '. $slideshow_speed .',
							animationSpeed: '. $animation_speed .',
							controlNav : false,
							directionNav: false,
							pauseOnHover: '. $pause_on_hover .',
							smoothHeight: false,
							controlNav : "thumbnails",
						});
					});
				});
			</script>';
		
		// Get Attachments
		$attachments = explode(",",$image_ids);
		$attachments = array_combine($attachments,$attachments);
		
		// Custom Links
		if ( $thumbnail_link == 'custom_link' ) {
			$custom_links = explode( ',', $custom_links);
		}

		//Output images
		if( $attachments ) :
		
			$unique_id = $unique_id ? ' id="'. $unique_id .'"' : NULL;

			// Image rendering
			if ( $img_rendering ) {
				$img_rendering = ' vcex-image-rendering-'. $img_rendering;
			}
		
			// Main wrapper div
			$output .= '<div class="vcex-flexslider-wrap clr vcex-img-galleryslider '. $img_rendering .'"'. $unique_id  .'>';

				$output .= '<div id="'. $unique_galleryslider_id .'" class="vcex-galleryslider flexslider"><ul class="slides">';
			
				// Loop through attachments
				$count=-1;
				foreach ( $attachments as $attachment ) :
				$count++;
				
					// Attachment VARS
					$attachment_link = get_post_meta( $attachment, '_wp_attachment_url', true );
					$attachment_img_url = wp_get_attachment_url( $attachment );
					$attachment_alt = strip_tags( get_post_meta($attachment, '_wp_attachment_image_alt', true) );
					$attachment_caption = get_post_field('post_excerpt', $attachment);
					
					// Load scripts
					if ( $thumbnail_link == 'lightbox' ) {
						wp_enqueue_script( 'vcex-magnific-popup' );
						wp_enqueue_script( 'vcex-lightbox' );
					}
					
					// Crop featured images if necessary
					$thumbnail_hard_crop = $img_height == '9999' ? false : true;
					$img_width = intval($img_width);
					$img_height = intval($img_height);
					$attachment_img = aq_resize( $attachment_img_url, $img_width, $img_height, $thumbnail_hard_crop );
					$img_thumb = aq_resize( $attachment_img_url, $img_thumb_width, $img_thumb_height, true );
					
					// Image output
					$image_output = '<img src="'. $attachment_img .'" alt="'. $attachment_alt .'" />';
		
					// Slide item start
					$output .= '<li class="vcex-galleryslider-slide slide" data-thumb="'. $img_thumb .'">';
					
							$output .= '<div class="vcex-galleryslider-entry-media">';
							
								if ( $thumbnail_link == 'lightbox' ) {
									$output .= '<a href="'. $attachment_img_url .'" title="'. $attachment_alt .'" class="vcex-galleryslider-entry-img vcex-lightbox">';
										$output .= $image_output;
									$output .= '</a>';
								} elseif ( $thumbnail_link == 'custom_link' ) {
									$custom_link = !empty($custom_links[$count]) ? $custom_links[$count] : '#';
									if ( $custom_link == '#' ) {
										$output .= $image_output;
									} else {
										$output .= '<a href="'. $custom_link .'" title="'. $attachment_alt .'" class="vcex-galleryslider-entry-img" target="'. $custom_links_target .'">';
											$output .= $image_output;
										$output .= '</a>';
									}
								} else {
									$output .= $image_output;
								}
								
								if ( $caption == 'true' && $attachment_caption ) {
									$output .= '<div class="vcex-galleryslider-entry-title">'. $attachment_caption .'</div>';
								}
								
							$output .= '</div>';
						
					// Close main wrap
					$output .= '</li>';
				
				// End foreach loop
				endforeach;
				
				// End UL
				$output .= '</ul>';
			
			// Close main wrap
			$output .= '</div></div><div class="vcex-clear-floats"></div>';
		
		endif; // End has posts check
		
		// Reset query
		wp_reset_postdata();

		// Return data
		return $output; 
		
	}
	add_shortcode("vcex_image_galleryslider", "vcex_image_galleryslider_shortcode");
}



/**
	Add to visual composer
**/
$vc_img_rendering_url = 'https://developer.mozilla.org/en-US/docs/Web/CSS/image-rendering';
vc_map( array(
	"name"					=> __( "Gallery Slider", 'vcex' ),
	"description"			=> __( "Image slider with thumbnail navigation", 'vcex' ),
	"base"					=> "vcex_image_galleryslider",
	"class"					=> "",
	"category"				=> __( "Sliders","vcex"),
	'admin_enqueue_js'		=> "",
	'admin_enqueue_css'		=> "",
	"icon" 					=> "icon-wpb-vcex-image_galleryslider",
	"params"				=> array(
		array(
			"type"			=> "attach_images",
			"admin_label"	=> true,
			"class"			=> "",
			"heading"		=> __( "Attach Images", 'vcex' ),
			"param_name"	=> "image_ids",
			"description"	=> __( "Select your gallery images.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Unique Id", 'vcex' ),
			"param_name"	=> "unique_id",
			"value"			=> "",
			"description"	=> __( "You can enter a unique ID here for styling purposes.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Image Link", 'vcex' ),
			"param_name"	=> "thumbnail_link",
			"value"			=> array(
				__( "None", "vcex" )			=> "none",
				__( "Lightbox", "vcex" )		=> "lightbox",
				__( "Custom Links", "vcex" )	=> "custom_link",
			),
		),
		array(
			"type"			=> "exploded_textarea",
			"heading"		=> __("Custom links", "vcex"),
			"param_name"	=> "custom_links",
			"description"	=> __('Enter links for each slide here. Divide links with linebreaks (Enter). For images without a link enter a # symbol. And don\'t forget to include the http:// at the front.', 'vcex'),
			"dependency"	=> Array(
				'element'	=> "thumbnail_link",
				'value'		=> array( 'custom_link' )
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __("Custom link target", "vcex"),
			"param_name"	=> "custom_links_target",
			"description"	=> __('Select where to open  custom links.', 'vcex'),
			"dependency"	=> Array('element' => "thumbnail_link", 'value' => array('custom_link')),
			"value"			=> array(
				__("Same window", "vcex")	=> "_self",
				__("New window", "vcex")	=> "_blank"
			)
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Main Image Crop Width", 'vcex' ),
			"param_name"	=> "img_width",
			"value"			=> "9999",
			"description"	=> __( "Enter a width in pixels.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Main Image Crop Height", 'vcex' ),
			"param_name"	=> "img_height",
			"value"			=> "400",
			"description"	=> __( 'Enter a height in pixels. Set to "9999" to disable vertical cropping and keep image proportions. Do not leave this setting blank, if you do and your images are not proportional the slider will not function perfectly', 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Thumbnail Image Crop Width", 'vcex' ),
			"param_name"	=> "img_thumb_width",
			"value"			=> "200",
			"description"	=> __( "Enter a width in pixels for your thumbnail image width. This won't increase the grid, its only used so you can alter the cropping to your preferred proportions.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Thumbnail Image Crop Height", 'vcex' ),
			"param_name"	=> "img_thumb_height",
			"value"			=> "200",
			"description"	=> __( "Enter a width in pixels for your thumbnail image height.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Image Rendering", 'vcex' ),
			"param_name"	=> "img_rendering",
			"value"			=> vcex_image_rendering(),
			"description"	=> sprintf( __( 'Image-rendering CSS property provides a hint to the user agent about how to handle its image rendering. For example when scaling down images they tend to look a bit fuzzy in Firefox, setting image-rendering to crisp-edges can help make the images look better. <a href="%s">Learn more</a>.', 'vcex' ), esc_url( $vc_img_rendering_url ) )
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Display Caption", 'vcex' ),
			"param_name"	=> "caption",
			"value"			=> array(
				__( "True", "vcex")		=> "true",
				__( "False", "vcex" )	=> "false",
			),
			"description"	=> __( "Display your image captions in the slider?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Animation", 'vcex' ),
			"param_name"	=> "animation",
			"value"			=> array(
				__( "Fade", "vcex" )	=> "fade",
				__( "Slide", "vcex")	=> "slide",
			),
			"description"	=> __( "Select your animation style.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Slideshow", 'vcex' ),
			"param_name"	=> "slideshow",
			"value"			=> array(
				__( "True", "vcex")		=> "true",
				__( "False", "vcex" )	=> "false",
			),
			"description"	=> __( "Enable automatic slideshow?", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Randomize", 'vcex' ),
			"param_name"	=> "randomize",
			"value"			=> array(
				__( "False", "vcex" )	=> "false",
				__( "True", "vcex")		=> "true",
			),
			"description"	=> __( "Randomize image order display on page load?", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Slideshow Speed", 'vcex' ),
			"param_name"	=> "slideshow_speed",
			"value"			=> "7000",
			"description"	=> __( "Enter your desired slideshow speed in milliseconds. Default is 7000.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Animation Speed", 'vcex' ),
			"param_name"	=> "animation_speed",
			"value"			=> "600",
			"description"	=> __( "Enter your desired animation speed in milliseconds. Default is 600.", 'vcex' ),
		),
	)
	
) );