<?php
/**
 * This file is used for all the styling options in the admin
 * All custom color options are output to the <head> tag
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
 */


if ( is_admin() ) return; // We don't need this in the admin


// Load CSS For Google Fonts
add_action('wp_head', 'wpex_typography');

if ( !function_exists( 'wpex_typography' ) ) {
	
	function wpex_typography() {
	
		$load_google_fonts = array();
		$css = $google_scripts = $google_fonts_css = '';

		// Array of standard fonts
		$standard_fonts = array(
			"Arial, Helvetica, sans-serif"							=> "Arial, Helvetica, sans-serif",
			"Tahoma, Geneva"										=> "Tahoma, Geneva",
			"'Tahoma,Geneva, sans-serif'"								=> "Tahoma,Geneva, sans-serif",
			"'Arial Black', Gadget, sans-serif"						=> "'Arial Black', Gadget, sans-serif",
			"'Bookman Old Style', serif"							=> "'Bookman Old Style', serif",
			"'Comic Sans MS', cursive"								=> "'Comic Sans MS', cursive",
			"Courier, monospace"									=> "Courier, monospace",
			"Garamond, serif"										=> "Garamond, serif",
			"Georgia, serif"										=> "Georgia, serif",
			"Impact, Charcoal, sans-serif"							=> "Impact, Charcoal, sans-serif",
			"'Lucida Console', Monaco, monospace"					=> "'Lucida Console', Monaco, monospace",
			"'Lucida Sans Unicode', 'Lucida Grande', sans-serif"	=> "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
			"'MS Sans Serif', Geneva, sans-serif"					=> "'MS Sans Serif', Geneva, sans-serif",
			"'MS Serif', 'New York', sans-serif"					=> "'MS Serif', 'New York', sans-serif",
			"'Palatino Linotype', 'Book Antiqua', Palatino, serif"	=> "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
			"Tahoma,Geneva, sans-serif"								=> "Tahoma, Geneva, sans-serif",
			"'Times New Roman', Times,serif"						=> "'Times New Roman', Times, serif",
			"'Trebuchet MS', Helvetica, sans-serif"					=> "'Trebuchet MS', Helvetica, sans-serif",
			"Verdana, Geneva, sans-serif"							=> "Verdana, Geneva, sans-serif",
		);
		
		/*------------------------------------------------*/
		/* Body
		/*------------------------------------------------*/
		$body_font = wpex_option( 'body_font' );
		if ( !empty($body_font) ) {
			
			// Vars
			$body_family = isset($body_font['font-family']) ? $body_font['font-family'] : "";
			$body_size = isset($body_font['font-size']) ? $body_font['font-size'] : "";
			$body_weight = isset($body_font['font-weight']) ? $body_font['font-weight'] : "";
			$body_color = isset($body_font['color']) ? $body_font['color'] : "";
			
			// Body font family
			if ( !empty($body_family) && 'inherit' != $body_family ) {
				$css .= 'body { font-family: '. $body_family .'; }';
				$load_google_fonts[] = $body_family;
			}
			
			// Body font size
			if ( !empty($body_size) && 'inherit' != $body_size ) {
				$css .= 'body { font-size: '. $body_size .'; }';
			}
			
			// Body font weight
			if ( !empty($body_weight) && 'inherit' != $body_weight ) {
				$css .= 'body { font-weight: '. $body_weight .' }';
			}
			
			// Body font color
			if ( !empty($body_color) && 'inherit' != $body_color ) {
				$css .= 'body { color: '. $body_color .' }';
			}
			
		}
		
		
		/*------------------------------------------------*/
		/* Headings
		/*------------------------------------------------*/
		$headings_font = wpex_option( 'headings_font' );
		if ( !empty($headings_font) ) {
			
			// Vars
			$headings_family = isset($headings_font['font-family']) ? $headings_font['font-family'] : "";
			$headings_weight = isset($headings_font['font-weight']) ? $headings_font['font-weight'] : "";
			
			// Body font family
			if ( $headings_family && 'inherit' != $headings_family ) {
				$css .= 'h1,h2,h3,h4,h5,h6,.theme-heading, .widget-title, .vc_text_separator { font-family: '. $headings_family .'; }';
				$load_google_fonts[] = $headings_family;
			}
			
			// Body font weight
			if ( $headings_weight ) {
				$css .= 'h1,h2,h3,h4,h5,h6,.theme-heading, .widget-title { font-weight: '. $headings_weight .' }';
			}
			
		}
		
		
		/*------------------------------------------------*/
		/* Logo
		/*------------------------------------------------*/
		$logo_font = wpex_option( 'logo_font' );
		if ( !empty($logo_font) ) {
			
			// Vars
			$logo_family = isset($logo_font['font-family']) ? $logo_font['font-family'] : "";
			$logo_size = isset($logo_font['font-size']) ? $logo_font['font-size'] : "";
			$logo_weight = isset($logo_font['font-weight']) ? $logo_font['font-weight'] : "";
			$logo_color = isset($logo_font['color']) ? $logo_font['color'] : "";
			
			// Body font family
			if ( !empty($logo_family) && 'inherit' != $logo_family ) {
				$css .= '#site-logo a { font-family: '. $logo_family .'; }';
				$load_google_fonts[] = $logo_family;
			}
			
			// Body font size
			if ( !empty($logo_size) ) {
				$css .= '#site-logo a { font-size: '. $logo_size .'; }';
			}
			
			// Body font weight
			if ( !empty($logo_weight) ) {
				$css .= '#site-logo a { font-weight: '. $logo_weight .' }';
			}
			
			// Body font color
			if ( !empty($logo_color) ) {
				$css .= '#site-logo a { color: '. $logo_color .' }';
			}
			
		}
		
		
		/*------------------------------------------------*/
		/* Menu
		/*------------------------------------------------*/
		$menu_font = wpex_option( 'menu_font' );
		if ( !empty($menu_font) ) {
			
			// Vars
			$menu_family = isset($menu_font['font-family']) ? $menu_font['font-family'] : "";
			$menu_size = isset($menu_font['font-size']) ? $menu_font['font-size'] : "";
			$menu_weight = isset($menu_font['font-weight']) ? $menu_font['font-weight'] : "";
			
			// Body font family
			if ( !empty($menu_family) && 'inherit' != $menu_family ) {
				$css .= '#site-navigation .sf-menu a { font-family: '. $menu_family .'; }';
				$load_google_fonts[] = $menu_family;
			}
			
			// Body font size
			if ( !empty($menu_size) ) {
				$css .= '#site-navigation .sf-menu a { font-size: '. $menu_size .'; }';
			}
			
			// Body font weight
			if ( !empty($menu_weight) ) {
				$css .= '#site-navigation .sf-menu a { font-weight: '. $menu_weight .' }';
			}

		}
		
		
		/*------------------------------------------------*/
		/* Menu Dropdowns
		/*------------------------------------------------*/
		$menu_dropdown_font = wpex_option( 'menu_dropdown_font' );
		if ( !empty($menu_dropdown_font) ) {
			
			// Vars	
			$menu_dropdown_family = isset($menu_dropdown_font['font-family']) ? $menu_dropdown_font['font-family'] : "";
			$menu_dropdown_size = isset($menu_dropdown_font['font-size']) ? $menu_dropdown_font['font-size'] : "";
			$menu_dropdown_weight = isset($menu_dropdown_font['font-weight']) ? $menu_dropdown_font['font-weight'] : "";
			
			// Body font family
			if ( !empty($menu_dropdown_family) && 'inherit' != $menu_dropdown_family ) {
				$css .= '#site-navigation .sf-menu ul a { font-family: '. $menu_dropdown_family .'; }';
				$load_google_fonts[] = $menu_dropdown_family;
			}
			
			// Body font size
			if ( !empty($menu_dropdown_size) ) {
				$css .= '#site-navigation .sf-menu ul a { font-size: '. $menu_dropdown_size .'; }';
			}
			
			// Body font weight
			if ( !empty($menu_dropdown_weight) ) {
				$css .= '#site-navigation .sf-menu ul a { font-weight: '. $menu_dropdown_weight .' }';
			}

		}
		
		
		/*------------------------------------------------*/
		/* Page Titles
		/*------------------------------------------------*/
		$page_header_font = wpex_option( 'page_header_font' );
		if ( !empty($page_header_font) ) {
			
			// Vars
			$page_header_family = isset($page_header_font['font-family']) ? $page_header_font['font-family'] : "";
			$page_header_size = isset($page_header_font['font-size']) ? $page_header_font['font-size'] : "";
			$page_header_weight = isset($page_header_font['font-weight']) ? $page_header_font['font-weight'] : "";
			$page_header_color = isset($page_header_font['color']) ? $page_header_font['color'] : "";
			
			// Body font family
			if ( !empty($page_header_family) && 'inherit' != $page_header_family ) {
				$css .= '.page-header-title { font-family: '. $page_header_family .'; }';
				$load_google_fonts[] = $page_header_family;
			}
			
			// Body font size
			if ( !empty($page_header_size) ) {
				$css .= '.page-header-title { font-size: '. $page_header_size .'; }';
			}
			
			// Body font weight
			if ( !empty($page_header_weight) ) {
				$css .= '.page-header-title { font-weight: '. $page_header_weight .' }';
			}
			
			// Body font color
			if ( !empty($page_header_color) ) {
				$css .= '.page-header-title { color: '. $page_header_color .' }';
			}

		}
		
		// trim white space for faster page loading
		$css =  preg_replace( '/\s+/', ' ', $css );
		
		// output css on front end
		if ( $css ) {
			$css_output = "<!-- Custom Fonts CSS -->\n<style type=\"text/css\">\n" . $css . "\n</style>";
		} else {
			$css_output = '';
		}
		if( $css_output ) {
			echo $css_output;
		}

		// Load Google Fonts CSS
		if ( $load_google_fonts ) {
			$load_google_fonts = array_unique($load_google_fonts);
			foreach ( $load_google_fonts as $load_google_font ) {
				if ( !in_array( $load_google_font, $standard_fonts ) ) {
					$google_scripts .= '<link href="https://fonts.googleapis.com/css?family='.str_replace(' ', '%20', $load_google_font).':300italic,400italic,600italic,700italic,800italic,400,300,600,700,800&amp;subset=latin,cyrillic-ext,greek-ext,greek,vietnamese,latin-ext,cyrillic" rel="stylesheet" type="text/css">';
				}
			}
			if ( $google_scripts ) {
				echo '<!-- Google Font Scripts -->'. $google_scripts;
			}
		}
		
	}
	
}