<?php
/*
 * Used for the search overlay
 *
 * @package WordPress
 * @subpackage Total
 * @since 1.1
*/


$wpex_header_style = wpex_option( 'header_style', 'one' );
if ( $wpex_header_style == 'one' ) {
	add_action( 'wpex_hook_header_inner', 'wpex_search_dropdown' );
}

if ( $wpex_header_style == 'three' ) {
	add_action( 'wpex_hook_main_menu_bottom', 'wpex_search_dropdown' );
}

if ( ! function_exists('wpex_search_dropdown') ) {
	
	function wpex_search_dropdown() {
		
		// Do nothing if the main search is disabled
		if ( wpex_option( 'main_search', '1' ) !== '1' ) return;
		
		// Only show on certain header styles
		$header_style = wpex_option( 'header_style', 'one' );
		if ( $header_style == 'one' || $header_style == 'three' ) { ?>
		
			<div id="searchform-dropdown" class="header-searchform-wrap clr">
				<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" role="search" class="header-searchform"><input type="search" name="s" autocomplete="off" placeholder="<?php _e( 'search', 'wpex' ); ?>" /></form>
			</div>
		
		<?php	
		} // End header style check
		
	} // End function
	
} // End if