<?php
/**
 * This file outputs all custom CSS for the theme
 * Google fonts, styling, layouts...etc.
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
 */


// We don't need this in the admin
if ( is_admin() ) return;

// The function
if ( !function_exists( 'wpex_output_css' ) ) {

	function wpex_output_css() {
	
		// Set output Var
		$output = '';

		// Custom Layouts
		$output .= wpex_layout_css();

		// Site Background
		$output .= wpex_site_background();

		// Per Page Backgrounds = After main background
		$output .= wpex_page_backgrounds();

		// Styling settings
		$output .= wpex_styling_css();

		// Custom CSS option
		// Call Last to make sure it overrides things
		$output .= wpex_custom_css();

		// Output CSS in WP_Head
		if ( $output ) {
			$output = "<!-- TOTAL CSS -->\n<style type=\"text/css\">\n" . $output . "\n</style>";
			echo $output;
		}

	} //end wpex_custom_css()

} // End if

// Hook function to wp_head
add_action('wp_head', 'wpex_output_css');