<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Pagina;
use App\Servicio;
use App\Portafolio;
use App\Cliente;
use App\Sociale;
use App\Slider;
use App\Post;
use App\Correo;
use App\Video;
use DB;

use Illuminate\Support\Facades\Mail;
use App\Mail\EnvioCorreoContactos;

class PaginaController extends Controller
{
   public function menu_pages(){
         
         //listado de paginas para el menu
        $menu_pages = Pagina::all();

        //listado de redes sociales
        $redes_sociales =Sociale::all();

        //pagina de inicio 
        $slider_inicio = Slider::query()->where('nombre', 'like', '%inicio%')->get();

        //cantidad de sliders
        $cantidad_sliders = Slider::query()->where('nombre', 'like', '%inicio%')->get()->count();

        //dd($cantidad_sliders);

        return view('pages.index',['paginas_menu' => $menu_pages,"redes_sociales"=>$redes_sociales,"slider"=>$slider_inicio,"cantidad_sliders"=>$cantidad_sliders]);
    }

    public function paginas_principales($slug){

        //listado de paginas para el menu
        $menu_pages = Pagina::all();

         //listado de redes sociales
        $redes_sociales =Sociale::all(); 

        //listado de servicios completos
        $servicio_lista = Servicio::all();

        //listado de contenido de pagina segun el slug
        $paginas = Pagina::findBySlug($slug);

        //consulta de grupos de portafolio para tabs
        $portafolios_tabs = DB::table('grupo_portafolios')->get();

        //consulta de todos los portafolios
        $portafolios_completos = Portafolio::all();

        //consulta de los videos de los portafolios
        $portafolios_videos_completos = Video::all();

        //consulta de categorias de blogs o post para tabs
        $blog_tabs = DB::table('categories')->get();

        //consulta de todos los BLOGS O POST
        $blog_completos = Post::all();
        //$listado_blog_relacion = $blog_completos->author();

        //consulta de carousel de clientes
        $cliente_carousel_lis = Cliente::all();

        /*foreach ($blog_completos as $key => $value) {
            dd($value->author->name);
        }*/
         
         //dd($paginas);

        //pagina de inicio 
        $slider_inicio = Slider::query()->where('nombre', 'like', '%servicio%')->get();

        //cantidad de sliders
        $cantidad_sliders = Slider::query()->where('nombre', 'like', '%servicios%')->get()->count();
         
        return view('pages.paginas',["paginas"=>$paginas,'paginas_menu' => $menu_pages,'servicios' =>$servicio_lista,"tabs_portafolio"=>$portafolios_tabs,"portafolios_todos"=>$portafolios_completos,'blog_tabs'=>$blog_tabs,'listado_post'=>$blog_completos,"clientes_listados"=> $cliente_carousel_lis,"redes_sociales"=>$redes_sociales,"portafolios_videos_completos"=>$portafolios_videos_completos, 'cantidad_sliders' => $cantidad_sliders, 'slider' => $slider_inicio]);
    }

    public function contactanos(Request $request){
         // dd($nombre);
           if($request->ajax()){

            /*$portafolio = DB::table('portafolios as port')
            ->where('port.id','=',$id->id)
            ->get();*/
           /* $portafolio=Portafolio::with('categorie')->where('id',$id->id)->get();
            $imagenes = "";
            foreach ($portafolio as $key => $value) {
                //dd($value->categorie->imagenes);
                $imagenes = $value->categorie->imagenes;
            }*/
            //dd($imagenes[0] );
            $nombre=$request->input('nombre');
            $telefono=$request->input('telefono');
            $email=$request->input('email');
            $comentario=$request->input('comentario');
            //insertar en la BD
            $registro = new Correo;

            /* Realizamos la asignación masiva */
            $registro->nombre = $nombre;
            $registro->telefono = $telefono;
            $registro->email = $email;
            $registro->comentario = $comentario;
            $registro->save();

            $correo = new Correo([
                'nombre'=>$nombre,
                "telefono"=>$telefono,
                "email"=>$email,
                "comentario"=>$comentario,
            ]);


            
           $mensaje="mensaje enviado correctamente";

           Mail::to('developer@rapiweb.pe','rapiweb')
             ->send(new EnvioCorreoContactos($correo));

                return response(['mensaje'=>$mensaje]);

      }
    }
}
